function channel = GenChannel(fc,BW_des,Nsub,TRX,Ptx,L,space)


x1 = TRX(1);y1 = TRX(2);z1 = TRX(3);
x2 = TRX(4);y2 = TRX(5);z2 = TRX(6);
z12 = z1^2;z22 = z2^2;

c = 3e8;
Ptx_lin = 10.^((Ptx-30)/10); % in watts
Lb = c/fc;
spac = Lb/2;
hp = 6.625e-34;
kb = 1.38e-23;
Tk = 290;

LIS_f = 0;
N = round(L/spac);

xcoord=linspace(-L/2,L/2,N);
ycoord=xcoord;
[xx,yy]=meshgrid(xcoord,ycoord);

a = (sqrt((xx-x1).^2+(yy-y1).^2+z1^2)+sqrt((xx-x2).^2+(yy-y2).^2+z2^2))/2;

Distmat = a*2;
Distmat1 = sqrt((xx-x1).^2+(yy-y1).^2+z1^2);
Distmat2 = sqrt((xx-x2).^2+(yy-y2).^2+z2^2);

freqvec=2*pi*linspace(fc-(1+space)*BW_des/2,fc+(1+space)*BW_des/2,Nsub*(1+space));
antt_delays=Distmat(:)/c;
AF_product=antt_delays*freqvec;
h_0 = (Distmat1(:)*freqvec/c).*(Distmat2(:)*freqvec/c);

        
Wb_mch=exp(-1i*AF_product)./h_0;
        
channel = Wb_mch;